uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform float u_Elapsed;

varying vec4 gl_TexCoord[];

void main(void)
{   


    vec4 vTexCoord = gl_TexCoord[0];
    

   highp vec4 back = texture2D(texture0,vTexCoord.xy);
   highp vec4 front = texture2D(texture1, vTexCoord.xy);
   highp vec4 clip = texture2D(texture2, vTexCoord.xy);
   
  
   //https://www.opengl.org/sdk/docs/tutorials/ClockworkCoders/lighting.php
   gl_FragColor =  ((( back + front  ) )  * gl_Color);
   gl_FragColor.rgb = gl_FragColor.rgb - vec3( min(0.1, abs(1.1-vTexCoord.x)) * 1.4);
   gl_FragColor.a = clip.a;

}